/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.drools.base.TypeResolver;
import org.drools.ide.common.client.modeldriven.testing.FactAssignmentField;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.server.testscenarios.populators.DateFieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.EnumFieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.ExpressionFieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.FactAssignmentFieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.SimpleFieldPopulator;

class FieldPopulatorFactory {
    private final Object factObject;
    private final TypeResolver typeResolver;
    private final ClassLoader classLoader;

    public FieldPopulatorFactory(Object factObject, TypeResolver typeResolver, ClassLoader classLoader) {
        this.factObject = factObject;
        this.typeResolver = typeResolver;
        this.classLoader = classLoader;
    }

    public FieldPopulator getFieldPopulator(Field field) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (field instanceof FieldData) {
            FieldData fieldData = (FieldData)field;
            if (fieldData.getValue() == null) {
                throw new IllegalArgumentException("Field value can not be null");
            }
            return this.getFieldDataPopulator(this.factObject, fieldData);
        }
        if (field instanceof FactAssignmentField) {
            return new FactAssignmentFieldPopulator(this.factObject, (FactAssignmentField)field, this.typeResolver, this.classLoader);
        }
        throw new IllegalArgumentException("Unknown field type " + field.getClass());
    }

    private FieldPopulator getFieldDataPopulator(Object factObject, FieldData fieldData) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (fieldData.getValue().startsWith("=")) {
            return new ExpressionFieldPopulator(factObject, fieldData.getName(), fieldData.getValue().substring(1));
        }
        if (fieldData.getNature() == 4L) {
            return new EnumFieldPopulator(factObject, fieldData.getName(), fieldData.getValue(), this.typeResolver, this.classLoader);
        }
        if (this.isDate(fieldData.getName())) {
            return new DateFieldPopulator(factObject, this.getFieldType(fieldData.getName()), fieldData.getName(), fieldData.getValue());
        }
        return new SimpleFieldPopulator(factObject, fieldData.getName(), fieldData.getValue());
    }

    private boolean isDate(String fieldName) {
        for (Method method : this.factObject.getClass().getDeclaredMethods()) {
            if (!this.hasMutator(fieldName, method) || !Date.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            return true;
        }
        return false;
    }

    private Class<?> getFieldType(String fieldName) {
        for (Method method : this.factObject.getClass().getDeclaredMethods()) {
            if (!this.hasMutator(fieldName, method)) continue;
            return method.getParameterTypes()[0];
        }
        throw new IllegalArgumentException("No field named: " + fieldName);
    }

    private boolean hasMutator(String fieldName, Method method) {
        return (method.getName().equals(fieldName) || method.getName().equals("set" + this.capitalize(fieldName))) && method.getParameterTypes().length == 1;
    }

    private String capitalize(String fieldName) {
        if (fieldName.length() == 0) {
            return "";
        }
        if (fieldName.length() == 1) {
            return fieldName.toUpperCase();
        }
        String firstLetter = fieldName.substring(0, 1);
        String tail = fieldName.substring(1);
        return firstLetter.toUpperCase() + tail;
    }
}

